//scilab 5.5.2 , OS: Ubuntu 14.04
//To determine the frequency response of a discrete-time system from its difference equation 

//Design steps: Given a0 y[n] = -a2 y[n-2] - a1 y[n-1] + b0 x[n] + b1 x[n-1] + b2 x[n-2] 
//1. System function  H(z) = b0 + b1  z -1 + b2  z -2 / 1 + a1 z -1 + a2  z -2
//2. Put z= e (jw) to  get the frequency response
//Design example: Plot the magnitude and phase response of the system represented by
//6y[n]+5y[n-1]+y[n-2]= 18x[n] + 8x[n-1]      


clear;clc;
close;
b=input('Enter the coefficients of x[n]');//[1 -1]]
a=input('Enter the coefficients of y[n]');//[1 -0.5]
//b=[18, 8];
//a=[6 5 1];
m= 0: length(b)-1; p=0:length(a)-1;
w=-2*%pi:%pi/100:2*%pi;//Plot over a interval of 4pi to observe periodicity
num = b* exp(-%i*m'*w);
den = a*exp(-%i*p'*w);
H= num./den;
magH = abs(H); angH= atan(imag(H),real(H));
figure;
subplot(211), plot( w, magH);
xtitle('Magnitude response','Frequency in rad','Magnitude');
subplot(212),plot(w, angH);
xtitle('Phase Response','Frequency in rad','Phase');
//Expected result
//H  =[5,3.5802695 - 1.3881467i,2.6 - i,2.253303 - 0.4785341i,2.1666667,2.253303 + 0.4785341i,2.6 + i,3.5802695 + 1.3881467i,5]  
